<div class="grid">
    <div class="plate grid_cell">
        <div class="plate_ttl __base ic_bulb">Как это работает?</div>
        <div class="content pad-wrap">
            <p>Система регулярно собирает информацию о структуре файлов и директорий сайта на сервере и сверяет их с предыдущим состоянием. При нахождении изменений уведомляет владельца.</p>
			
			<p>Для начала работы перейдите в <a href="/projects/">проекты</a> и заведите новый, указав домен сайта, который будет мониториться. Остальные параметры заполнены по умолчанию, но, если требуется, их можно изменить. После сохранения, скачайте уникальный PHP-файл сканера и загрузите его на сервер по тому пути, что указан в параметрах. По умолчанию, он располагается в корневой директории.</p>
            <p>После добавления проекта, если файл сканера установлен правильно, через 10 минут соберется первая структура файлов и директорий. При каждой новой проверке, в случае каких либо изменений, система уведомит об этом и сохранит новую структуру.</p>
        </div>
    </div>
    <div class="plate grid_cell">
        <div class="plate_ttl __primary ic_user">Пользователи системы</div>
        <table class="tbl-base __no-brd">
        <?$users = Serval::call('db')->Select("mod_users","","","ORDER BY id DESC LIMIT 4");
					foreach ($users as $val) {?>
            <tr>
                <td><a href="#"><?=$val['fio']?></a></td>
                <td></td>
                <td>
                <?if ($val['type']=="admin") {?>
                    <span class="__admin">Администратор</span>
                <?} else {?>
                    <span class="__user">Пользователь</span>
                <?}?>
                </td>
            </tr>
        <?}?>
        </table>
    </div>
</div>

<?if($this->getList){?>
<div class="plate">
    <div class="plate_ttl __secondary ic_watch">Изменения файлов</div>
    <table class="tbl-base __no-brd __tggl-rows">
        <?foreach ($this->getList as $val) {
					$val['domain'] = str_replace("www.","",$val['domain']);
				?>
            <tbody>
		            <tr>
	                <td><?=$val['date']?></td>
	                <td><a href="#edit_project" data-id="<?=$val['project_id']?>"><?=$val['domain']?></a></td>
	                <td>Владелец: <a href="#profile" data-id="<?=$val['users_id']?>"><?=$val['createUser']?></a></td>
	                <td class="bttns-wrap">
	                    <a href="/projects/<?=$val['project_id']?>/log/" data-type="iframe" class="open-dialog btn __primary-inverse ic_log" data-title="Лог изменений для <span><?=$val['domain']?></span>">Смотреть изменения</a>
	                    <a href="/projects/<?=$val['project_id']?>/structure/" data-type="iframe" class="open-dialog btn __primary-inverse ic_structure" data-title="Структура для <span><?=$val['domain']?></span>">Структура</a>
	                    <?if($val['_warning']>0){?>
						<a href="#" onclick="return false;" class="btn __base-inverse tggl-btn ic_arr-bot">Развернуть</a>
						<?}?>
	                </td>
	            </tr>
	            <?if($val['status']=="error"){?>
				        <tr class="__disabled">
				            <td colspan="5">
				                <span class="ic_warning"></span> <?=$val['error_msg']?>
                        <a href="#verified_error" data-project_id="<?=$val['project_id']?>" class="btn">Исправлено</a>
				            </td>
				        </tr>
	            <?}?>
	            <tr class="tggl-block hidden">
	            	<td colspan="4" data-id="loginfo" valign="top">
									<?if($val['_warning']>0){?>
										<a href="#loginfoAll" class="btn">Развернуть все</a>
										<a href="#verified_open_ok" data-project_id="<?=$val['project_id']?>" class="btn">Установить "Все ок" для открытых</a>
									<?}?>
									
									<table class="tbl-base __no-brd __tggl-rows">
							        <?foreach ($val['_log'] as $v) {?>
							            <tbody data-project_id="<?=$val['project_id']?>" data-scan_id="<?=$v['id']?>">
							            <?switch($v['status']){
														case 'error':
															?>
												        <tr class="__disabled">
												            <td><?=$v['date']?></td>
												            <td><a href="#edit_project" data-id="<?=$v['project_id']?>"><?=$v['domain']?></a></td>
												            <td>Владелец: <a href="#profile" data-id="<?=$v['users_id']?>"><?=$v['createUser']?></a></td>
												            <td class="disabled-wrap">
												                <span class="ic_warning"></span> <?=$v['error_msg']?>
												                <a href="#verified_error" data-project_id="<?=$v['project_id']?>" class="btn">Исправлено!</a>
												            </td>
												        </tr>
															<?
														break;
														default:?>
									            <tr>
									                <td><?=$v['date']?></td>
									                <td><a href="#edit_project" data-id="<?=$v['project_id']?>"><?=$v['domain']?></a></td>
									                <td>Владелец: <a href="#profile" data-id="<?=$v['users_id']?>"><?=$v['createUser']?></a></td>
									                <td class="bttns-wrap">
									                    <a href="#loginfo" data-project_id="<?=$v['project_id']?>" data-scan_id="<?=$v['id']?>" class="btn __base-inverse tggl-btn ic_arr-bot">Развернуть</a>
									                </td>
									            </tr>
									            <tr class="tggl-block hidden">
									            	<td colspan="4" data-id="loginfo" valign="top">
																	
																</td>		            
									            </tr>
														<?
													}?>
							            </tbody>
							        <?}?>
							    </table>
								</td>		            
	            </tr>
            </tbody>
        <?}?>
    </table>
</div>
<?}?>